/*
 * Decompiled with CFR 0.152.
 */
package Game_Engine.levelEditor.editor_components;

import BryceMath.Calculations.Colors;
import Data_Structures.Structures.BitSet;
import Data_Structures.Structures.HashingClasses.Dict;
import Game_Engine.Engine.Objs.ImageB;
import Game_Engine.Engine.Objs.Obj;
import Game_Engine.Engine.Objs.obj_scalable;
import Game_Engine.GUI.Components.small.gui_handle;
import Game_Engine.SpriteFactories.ArrowImageFactory;
import Game_Engine.levelEditor.editor_components.gui_level_editor;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.PrintStream;
import util.Serializations;

public abstract class obj_entity
extends obj_scalable {
    public String name;
    private String text = "";
    private BitSet direction_properties = new BitSet();
    private static boolean showKnobs = false;
    private gui_handle knob1;
    private gui_handle knob2;
    protected int x2;
    protected int y2;

    public obj_entity(double x, double y, BufferedImage spr, String name, String parameter) {
        super(x, y);
        this.sprite = spr;
        this.name = name == null ? "" : name;
        this.text = parameter == null ? "" : parameter;
        this.knob1 = new gui_handle(this.getX(), this.getY(), this.sprite.getWidth(), this.sprite.getHeight());
        this.knob2 = new gui_handle(this.getX(), this.getY(), this.sprite.getWidth(), this.sprite.getHeight());
    }

    @Override
    public void initialize() {
        super.initialize();
        this.knob1.setText("O");
        this.knob2.setText("O");
        this.knob1.setRestingColor(Colors.Color_hsv(0.0, 0.0, 0.0, 25.0));
        this.knob2.setRestingColor(Colors.Color_hsv(0.0, 0.0, 0.0, 25.0));
        this.myContainer.obj_create((Obj)this.knob1);
        this.myContainer.obj_create((Obj)this.knob2);
    }

    public abstract obj_entity clone(int var1, int var2);

    @Override
    public void serializeTo(PrintStream stream) {
        stream.println(this.name);
        Dict<String> dict = new Dict<String>();
        dict.insert("x", "" + (int)this.getX());
        dict.insert("y", "" + (int)this.getY());
        dict.insert("x2", "" + this.x2);
        dict.insert("y2", "" + this.y2);
        int dp = this.direction_properties.toInt();
        if (dp == 0 || dp == 255) {
            dp = -1;
        }
        dict.insert("dir", "" + dp);
        String parameter = this.getText();
        if (parameter.length() > 0) {
            dict.insert("p1", parameter);
        }
        this.addSerialProperties(dict);
        Serializations.serial_dict(stream, dict);
    }

    protected abstract void addSerialProperties(Dict<String> var1);

    @Override
    public void update() {
        if (showKnobs) {
            this.knob1.show();
            this.knob2.show();
        } else {
            this.knob1.hide();
            this.knob2.hide();
        }
        int x1 = (int)this.knob1.getX();
        int y1 = (int)this.knob1.getY();
        this.moveTo(x1, y1);
        int x2 = (int)this.knob2.getX();
        int y2 = (int)this.knob2.getY();
        this.arg2(x2, y2);
    }

    public void arg2(int x2_in, int y2_in) {
        this.knob2.moveTo(x2_in, y2_in);
        gui_level_editor.grid_drawer.snapToGrid(this.knob1);
        gui_level_editor.grid_drawer.snapToGrid(this.knob2);
        int x1 = (int)Math.min(this.knob1.getX(), this.knob2.getX());
        int y1 = (int)Math.min(this.knob1.getY(), this.knob2.getY());
        this.moveTo(x1, y1);
        this.x2 = (int)Math.max(this.knob1.getX(), this.knob2.getX());
        this.y2 = (int)Math.max(this.knob1.getY(), this.knob2.getY());
        double v_scale_old = this.v_scale;
        double h_scale_old = this.h_scale;
        this.v_scale = Math.abs(this.y2 - y1) / this.sprite.getHeight() + 1;
        this.h_scale = Math.abs(this.x2 - x1) / this.sprite.getWidth() + 1;
    }

    @Override
    protected void die() {
        super.die();
        this.knob1.kill();
        this.knob2.kill();
    }

    @Override
    public void mouseP(int mx, int my) {
        if (this.mouse_right()) {
            this.die();
        }
    }

    @Override
    public void mouseD(int mx, int my) {
        if (this.mouse_right()) {
            this.die();
        }
    }

    @Override
    public void draw(ImageB image, AffineTransform AT) {
        super.draw(image, AT);
        Graphics2D g = image.getGraphics();
        double x = this.getX();
        double y = this.getY();
        int w = this.getW();
        int h = this.getH();
        if (this.text.length() != 0) {
            this.drawTextCenter(image.getGraphics(), AT, x + (double)(w / 2), y + (double)(h / 2), this.text, 10);
        }
        if (this.mouseInRegion) {
            g.setColor(Color.BLUE);
            this.drawRect(g, AT, x + 1.0, y + 1.0, w - 2, h - 2);
        }
    }

    @Override
    public void tileDraw(ImageB image, AffineTransform AT, int x, int y, int w, int h) {
        this.drawRadialArray(image.getGraphics(), AT, ArrowImageFactory.getArrows(64), this.direction_properties, x, y, w, h);
    }

    public void setText(String input) {
        this.text = input;
    }

    public String getText() {
        return this.text;
    }

    public void setDirectionsAttributes(BitSet set) {
        this.direction_properties = set;
    }

    public static void setShowKnobs(boolean b) {
        showKnobs = b;
    }
}

